var sectionsData = [
    {
        name: "Play Content",
        link: "../integration/scenarios/media/index.html",
        description: "The various ways which content can be specified to play",
        subs: [
            {
                name: "Inline",
                link: "../integration/scenarios/media/play-inline.html",
                examples: [
                    {
                        title: "Progressive via String",
                        description: "Play Progressive content by providing the asset data inline as a string",
                        link: "basic/play/inline/string/mp4.html",
                        category: ''
                    },
                    {
                        title: "VOD via Object",
                        description: "Play VOD content by providing asset data inline as an object",
                        link: "basic/play/inline/object/vod.html",
                        category: ''
                    },
                    {
                        title: "Live via Object",
                        description: "Play Live content by providing asset data inline as an object",
                        link: "basic/play/inline/object/live.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Remote - Media Json",
                link: "../integration/scenarios/media/play-remote.html#media-json",
                examples: [
                    {
                        title: "Default",
                        description: "Play media.json content with default configuration",
                        link: "basic/play/remote/mediajson/default.html",
                        category: 'media.json'
                    },
                    {
                        title: "Override Init Config",
                        description: "Play media.json content, overridding default config values via the init config. Subsequent media.json play calls will use these same overrides",
                        link: "basic/play/remote/mediajson/override_init.html",
                        category: 'media.json'
                    },
                    {
                        title: "Override Play Data",
                        description: "Play media.json content, overridding default config values via the play data. Subsequent media.json play calls will not use these overrides",
                        link: "basic/play/remote/mediajson/override_play.html",
                        category: 'media.json'
                    }
                ]
            },
            {
                name: "Remote - Content XML",
                link: "../integration/scenarios/media/play-remote.html#content-xml",
                examples: [
                    {
                        title: "Progressive",
                        description: "Play Progressive content by providing the asset data from a content.xml file",
                        link: "basic/play/remote/contentxml/mp4.html",
                        category: 'content.xml'
                    },
                    {
                        title: "VOD",
                        description: "Play VOD content by providing the asset data from a content.xml file",
                        link: "basic/play/remote/contentxml/vod.html",
                        category: 'content.xml'
                    },
                    {
                        title: "Live",
                        description: "Play Live content by providing the asset data from a content.xml file",
                        link: "basic/play/remote/contentxml/live.html",
                        category: 'content.xml'
                    },
                    {
                        title: "Select File",
                        description: "Demonstrating the selectFile config method, filters which media &lt;file&gt; nodes in the content.xml to play ",
                        link: "basic/play/remote/contentxml/select_file.html",
                        category: 'content.xml'
                    }
                ]
            },
            {
                name: "Playlist",
                examples: [
                    {
                        title: "Mixed",
                        description: "Playing Progressive and VOD content in a playlist",
                        link: "basic/play/playlist/mixed.html",
                        category: ''
                    }
                ]
            }
        ]
    },
    {
        name: "Ads",
        link: "../integration/scenarios/ads/index.html",
        description: "How to configure preroll and postroll ads",
        subs: [
            {
                name: "Preroll",
                link: "../integration/scenarios/ads/preroll.html",
                examples: [
                    {
                        title: "Progressive",
                        description: "Configuring pre-roll ads for Progressive content",
                        link: "basic/ads/preroll/mp4.html",
                        category: 'config'
                    },
                    {
                        title: "VOD",
                        description: "Configuring pre-roll ads for HLS content",
                        link: "basic/ads/preroll/vod.html",
                        category: 'config'
                    },
                    {
                        title: "Live",
                        description: "Configuring pre-roll ads for Live HLS content",
                        link: "basic/ads/preroll/live.html",
                        category: 'config'
                    },
                ]
            },
            {
                name: "Postroll",
                examples: [
                    {
                        title: "Progressive",
                        description: "Configuring post-roll ads for Progressive content",
                        link: "basic/ads/postroll/mp4.html",
                        category: "config"
                    },
                    {
                        title: "VOD",
                        description: "Configuring post-roll ads for HLS content",
                        link: "basic/ads/postroll/vod.html",
                        category: "config"
                    }
                ]
            }
        ]
    },
    {
        name: "Events",
        link: "../integration/scenarios/events/index.html",
        description: "Listen for player events",
        subs: [
            {
                name: "Init",
                link: "../integration/scenarios/events/init.html",
                examples: [
                    {
                        title: "Map",
                        description: "Configuring event listeners via a map on the init config",
                        link: "basic/events/init/map/mp4_pre.html",
                        category: ''
                    },
                    {
                        title: "Collection",
                        description: "Configuring event listeners via a collection on the init config",
                        link: "basic/events/init/collection/mp4_pre.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Player",
                link: "../integration/scenarios/events/player.html",
                examples: [
                    {
                        title: "Single",
                        description: "Configuring a single event listener on the player instance",
                        link: "basic/events/player/single/mp4.html",
                        category: ''
                    },
                    {
                        title: "Map",
                        description: "Configuring event listeners via a map on the player instance",
                        link: "basic/events/player/map/mp4_pre.html",
                        category: ''
                    },
                    {
                        title: "Collection",
                        description: "Configuring event listeners via a collection on the player instance",
                        link: "basic/events/player/collection/mp4_pre.html",
                        category: ''
                    }
                ]
            }
        ]
    },
    {
        name: "Config",
        link: "../integration/scenarios/configuration/index.html",
        description: "Various ways to configure specific player behavior",
        subs: [
            {
                name: "Adhoc",
                link: "../integration/scenarios/configuration/levels.html#adhoc",
                examples: [
                    {
                        title: "Ads",
                        description: "Update the ads config after the player has initialized.",
                        link: "basic/config/adhoc/update/ads_pre.html",
                        category: 'preroll'
                    },
                    {
                        title: "MinBitrate",
                        description: "Update the media minBitrate after the player has initialized (requires bandwidth throttling).",
                        link: "basic/config/adhoc/update/minbitrate.html",
                        category: ''
                    },
                    {
                        title: "MaxBitrate",
                        description: "Update the media maxBitrate after the player has initialized.",
                        link: "basic/config/adhoc/update/maxbitrate.html",
                        category: ''
                    },
                    {
                        title: "StartIndex",
                        description: "Update the media startIndex after the player has initialized.",
                        link: "basic/config/adhoc/update/startindex.html",
                        category: ''
                    },
                ]
            },
            {
                name: "Autoplay",
                link: "../integration/scenarios/autoplay/index.html",
                examples: [
                    {
                        title: "Force Media",
                        description: "Force content to auto start, content starts in a muted state until user gesture unmutes",
                        link: "basic/config/player/autoplay/force_media.html",
                        category: ''
                    },
                    {
                        title: "No AutoPlay",
                        description: "Prevent media from auto starting, user gesture required to start playback",
                        link: "basic/config/player/autoplay/no.html",
                        category: ''
                    },
                    {
                        title: "No AutoPlay w/ Preroll",
                        description: "Prevent ads / media from auto starting, user gesture required to start playback",
                        link: "basic/config/player/autoplay/no_pre.html",
                        category: 'ads,preroll'
                    },
                    {
                        title: "No AutoPlay using Native Controls",
                        description: "Prevent media from auto starting, user gesture required to start playback. Native UI does not call proceed so external button must be provided.",
                        link: "basic/config/player/autoplay/no_native.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Click to Play",
                link: "../integration/scenarios/autoplay/click.html",
                examples: [
                    {
                        title: "Synchronous",
                        description: "Play via external click to play button",
                        link: "basic/config/player/clicktoplay/sync.html",
                        category: ''
                    },
                    {
                        title: "Asynchronous Default",
                        description: "Play via external click to play button after doing an asynchronous task",
                        link: "basic/config/player/clicktoplay/async_default.html",
                        category: ''
                    },
                    {
                        title: "Asynchronous User Action",
                        description: "Play via external click to play button after registering a user action then doing an asynchronous task",
                        link: "basic/config/player/clicktoplay/async_user_action.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Initial Player Value",
                link: "../integration/scenarios/initial/index.html",
                examples: [
                    {
                        title: "Initial Volume",
                        description: "Configure the player's initial volume level for content",
                        link: "basic/config/player/initial/volume.html",
                        category: 'sound'
                    },
                    {
                        title: "Initial Muted",
                        description: "Configure the player's muted value for content",
                        link: "basic/config/player/initial/muted.html",
                        category: 'sound'
                    }
                ]
            },
            {
                name: "Offset",
                examples: [
                    {
                        title: "Play",
                        description: "Start playback by an offset configured in the play options",
                        link: "basic/config/media/offset/play.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Persist",
                link: "../integration/scenarios/persistence/index.html",
                examples: [
                    {
                        title: "Default",
                        description: "By default persistence is enabled for all persistable properties. Adjust volume/mute values and refresh the page to see those values persist on subsequent player visits.",
                        link: "basic/config/player/persist/default.html",
                        category: 'sound'
                    },
                    {
                        title: "Volume Only",
                        description: "Only persisting the volume level. Adjust volume/mute values and refresh the page to see only volume persists.",
                        link: "basic/config/player/persist/volume.html",
                        category: 'sound'
                    },
                    {
                        title: "Disabled",
                        description: "Demonstrates how to disable persistence (enabled by default). Refreshing the page will set the player default values for volume/mute.",
                        link: "basic/config/player/persist/disabled.html",
                        category: 'sound'
                    }
                ]
            },
            {
                name: "Play Mode",
                link: "../integration/scenarios/playmode/index.html",
                examples: [
                    {
                        title: "Default",
                        description: "The playsinline is not set on video elements, media goes fullscreen on iPhone",
                        link: "basic/config/player/playmode/default.html",
                        category: ''
                    },
                    {
                        title: "Inline",
                        description: "The playsinline attribute is set on video elements, media does not go fullscreen on iPhone",
                        link: "basic/config/player/playmode/inline.html",
                        category: ''
                    },
                    {
                        title: "Inline w/ Preroll",
                        description: "The playsinline attribute is set on video elements, ads and media do not go fullscreen on iPhone",
                        link: "basic/config/player/playmode/inline_pre.html",
                        category: 'preroll,ads'
                    },
                    {
                        title: "AutoPlay Override",
                        description: "Forcing media to autoPlay will override the default playMode, the playsinline attribute will be set on the video elements, media does not go fullscreen on iPhone",
                        link: "basic/config/player/playmode/autoplay/override.html",
                        category: ''
                    }
                ]
            },
            {
                name: "String Replacement",
                // link: "../integration/scenarios/configuration/replace/index.html",
                examples: [
                    {
                        title: "Javascript",
                        description: "Config string replacement using the 'javascript' prefix",
                        link: "basic/config/replace/javascript.html",
                        category: ''
                    },
                    {
                        title: "Ads",
                        description: "Ad config string replacement is done as the request is about to be sent. Each request will perform replacement on the ads config.",
                        link: "basic/config/replace/ads.html",
                        category: 'javascript'
                    }
                ]
            }
        ]
    },
    {
        name: "Plugins",
        description: "Set up 3rd party add-ons",
        subs: [
            {
                name: "Analytics",
                link: "../integration/scenarios/analytics/index.html",
                examples: [
                    {
                        title: "Akamai",
                        description: "Configure the Akamai analytics plugin",
                        link: "basic/plugins/analytics/akamai/default.html",
                        category: 'config'
                    },
                    {
                        title: "Conviva",
                        description: "Configure the Conviva analytics plugin",
                        link: "basic/plugins/analytics/conviva/default.html",
                        category: 'config'
                    },
                    {
                        title: "Conviva External",
                        description: "Create the Conviva analytics plugin externally to allow analytics to be gathered before the player is initialized",
                        link: "basic/plugins/analytics/conviva/external.html",
                        category: 'config'
                    }
                ]
            }
        ]
    },
    {
        name: "UI",
        link: "../integration/scenarios/ui/index.html",
        description: "Options for player controls",
        subs: [
            {
                name: "Controls",
                examples: [
                    {
                        title: "Native Controls",
                        description: "Configure the player to use native controls",
                        link: "basic/ui/controls/ui_native_controls.html",
                        category: 'config'
                    },
                    {
                        title: "No Controls",
                        description: "Configure the player to use no controls",
                        link: "basic/ui/controls/ui_no_controls.html",
                        category: 'config'
                    }
                ]
            },
            {
                name: "Poster Image",
                examples: [
                    {
                        title: "Progressive",
                        description: "Setting a posting image on video player",
                        link: "basic/ui/poster/mp4.html",
                        category: 'image,poster'
                    }
                ]
            },
            {
                name: "Reactive",
                examples: [
                    {
                        title: "Resize",
                        description: "Example of resizing the player reactively, fill up the screen",
                        link: "basic/ui/reactive/resize.html",
                        category: ''
                    },
                    {
                        title: "Resize w/ Preroll",
                        description: "Example of resizing the player reactively, fill up the screen with pre-roll ads",
                        link: "basic/ui/reactive/resize_pre.html",
                        category: ''
                    },
                    {
                        title: "Resize Alternative",
                        description: "Alternative example of resizing the player reactively",
                        link: "basic/ui/reactive/resize_alt.html",
                        category: ''
                    },
                    {
                        title: "Resize Alternative w/ Preroll",
                        description: "Alternative example of resizing the player reactively, with pre-roll ads",
                        link: "basic/ui/reactive/resize_alt_pre.html",
                        category: ''
                    }
                ]
            }
        ]
    },
    {
        name: "Auth",
        link: "../integration/scenarios/auth/index.html",
        description: "Playing content that requires authentication via Adobe token service",
        subs: [
            {
                name: "Basic",
                examples: [
                    {
                        title: "Default",
                        description: "Playing authenticated content with the default auth type",
                        link: "basic/config/auth/default.html",
                        category: ''
                    },
                    {
                        title: "Override",
                        description: "Playing authenticated content, overridding the auth type with a different service url",
                        link: "basic/config/auth/override.html",
                        category: ''
                    },
                    {
                        title: "Custom",
                        description: "Playing authenticated content, defining a custom auth type",
                        link: "basic/config/auth/custom.html",
                        category: ''
                    }
                ]
            },
            {
                name: "Remote",
                examples: [
                    {
                        title: "Media Json",
                        description: "Play authenticaed content via media.json",
                        link: "basic/config/auth/media_json.html",
                        category: ''
                    }
                ]
            }
        ]
    },
    {
        name: "Simulcast",
        // link: "../integration/simulcast/...",  TODO
        description: "Play content that's on TV on the web",
        subs: [
            {
                name: "DAI",
                link: "../integration/features/dai.html",
                examples: [
                    {
                        title: "Default settings, test stream",
                        description: "An example of the minimum config needed for a live stream to use DAI, using the VOD-to-Live test stream",
                        link: "basic/simulcast/dai/default.html",
                        category: 'midroll'
                    },
                    {
                        title: "Toggle asset iD used, test stream",
                        description: "An example of using the DAI feature config to specify the configured assetId is sent on the midroll (instead of the stream assetId), using the VOD-to-Live test stream",
                        link: "basic/simulcast/dai/feature-assetId.html",
                        category: 'midroll'
                    },
                    {
                        title: "Default settings, authenticated stream",
                        description: "An example of the minimum config needed for a live Simulcast stream to use DAI, using the CNNGo stream",
                        link: "basic/simulcast/dai/auth.html",
                        category: 'midroll'
                    }
                ]
            }
        ]
    },
    {
        name: "TVE",
        link: "../integration/features/tve.html",
        description: "Play TV Everywhere",
        subs: [
            {
                name: "Media Json",
                examples: [
                    {
                        title: "C4",
                        description: "Play auth content C4 content via media.json",
                        link: "basic/tve/mediajson/c4.html",
                        category: 'media.json'
                    }
                ]
            },
            {
                name: "Content Xml",
                examples: [
                    {
                        title: "C4",
                        description: "Play auth content with C4 ads via content.xml ",
                        link: "basic/tve/contentxml/c4.html",
                        category: 'segments,content.xml'
                    },
                    {
                        title: "C5 as C4",
                        description: "Play auth content with C5 ads via content.xml ",
                        link: "basic/tve/contentxml/c5_as_c4.html",
                        category: 'adblocks,content.xml'
                    },
                    {
                        title: "Legacy",
                        description: "Play auth content via content.xml that has older version of the auth xml",
                        link: "basic/tve/contentxml/legacy.html",
                        category: 'adblocks,content.xml'
                    },
                ]
            }
        ]
    },
    {
        name: "Features",
        link: "../integration/features/index.html",
        description: "Allow for configuration of specific use cases",
        subs: [
            {
                name: "Amazon A9",
                examples: [
                    {
                        title: "Default",
                        description: "Enable Amazon A9 ads with the default configuration",
                        link: "basic/features/amazona9/default.html",
                        category: ''
                    }
                ]
            }
        ]
    }
];