// Generates a midroll ad response with FW dev ads that start
// at the requested time and fill up an arbitrary break duration

(function devads_main() {
    var fwInstanceContext = "Context_" + (tv.freewheel.SDK._instanceCounter - 1);
    var fwInstance = tv.freewheel.SDK._instanceQueue[fwInstanceContext];

    var adQueryParams = TOP.utils.Url.parse(
        fwInstance._adRequest.generateTypeBRequestUrl()
    ).queryAsMap();

    if (adQueryParams.slau !== 'midroll') {
        fwInstance.requestComplete({});
        return;
    }

    var maxDuration = adQueryParams.maxd || '5';

    var adData = devads_generateAdResponse(
        parseFloat(adQueryParams.tpos, 10),
        parseFloat(maxDuration, 10)
    );

    fwInstance.requestComplete(adData);
})();

function devads_generateAdResponse(time, duration) {
    var data = {
        version: "1",
        networkId: "42448",
        parameters: [{
                name: "autoloadExtensions",
                category: "profile",
                value: "https:\/\/z.moatads.com\/freewheel353205095517817\/MoatFreeWheelJSPEM.js,https:\/\/static.adsafeprotected.com\/IASFreewheelExtension.js"
            },
            {
                name: "translator.vast.loadWithCookie",
                category: "profile",
                value: "true"
            },
            {
                name: "skipOverflowAdInLive",
                category: "profile",
                value: "true"
            },
            {
                name: "replaceMissingCompanion",
                category: "profile",
                value: "ad"
            }
        ],
        rendererManifest: {
            adRenderers: {
                version: "1",
                adRenderer: [{
                        name: "g_html5_video_mp4",
                        url: "class:\/\/VideoRenderer",
                        contentType: "video\/mp4-h264,video\/mp4,video\/m4v,video\/mp4-mpeg4,video\/mp4-mpeg4_simple,video\/m4v-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video\/mp4-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video\/mov-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video\/m4v-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video\/mp4-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video\/mov-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video\/m4v-mpeg4-640-480-less_eq_2500_kbps-aaclc,video\/mp4-mpeg4-640-480-less_eq_2500_kbps-aaclc,video\/mov-mpeg4-640-480-less_eq_2500_kbps-aaclc,video\/mp4-h264-baseline,",
                        adUnit: "video,slate,",
                        slotType: "preroll,midroll,postroll,",
                        creativeApi: "None,"
                    },
                    {
                        name: "g_html5_null",
                        url: "class:\/\/NullRenderer",
                        contentType: "null\/null,",
                        adUnit: "video,linear-animation,generic-overlay,app-interstitial,",
                        slotType: "preroll,midroll,postroll,overlay,display,pause_midroll,",
                        creativeApi: "None,"
                    },
                    {
                        name: "g_html5_vpaid",
                        url: "class:\/\/VPAIDRenderer",
                        contentType: "text\/js_ref,",
                        adUnit: "video,fixed-size-interactive,app-interstitial,",
                        slotType: "preroll,midroll,postroll,overlay,",
                        creativeApi: "VPAID,"
                    },
                    {
                        name: "g_html5_vast_desktop",
                        url: "class:\/\/VastTranslator",
                        contentType: "external\/vast-2,",
                        adUnit: "video,still-image,fixed-size-interactive,text-ad,linear-animation,generic-overlay,video-click-to-content,slate,logo,logo-click-to-content,app-interstitial,",
                        slotType: "preroll,midroll,postroll,overlay,display,",
                        parameter: [{
                            name: "translator.vast.asyncLoad",
                            value: "true"
                        }],
                        creativeApi: "VPAID,MRAID-1.0,None,"
                    },
                    {
                        name: "g_html5_html_wo_mraid_since_5.13",
                        url: "class:\/\/HTMLRenderer",
                        contentType: "text\/html_doc_ref,text\/html_doc_lit_mobile,text\/html_lit_nowrapper,",
                        adUnit: "video,still-image,fixed-size-interactive,text-ad,logo-text-ad,linear-animation,generic-overlay,text-ad-click-to-content,still-image-click-to-content,generic-overlay-click-to-content,logo-text-ad-click-to-content,slate,logo,logo-click-to-content,player-skin,generic-overlay-click-to-content2,variable-size-interactive,app-interstitial,",
                        slotType: "preroll,midroll,postroll,overlay,display,",
                        creativeApi: "None,"
                    }
                ]
            }
        },
        visitor: {
            httpHeaders: [],
            state: []
        },
        errors: {
            errors: []
        },
        eventCallbacks: {
            eventCallbacks: [{
                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022",
                type: "GENERIC",
                use: "BASE",
                showBrowser: false,
                trackingUrls: []
            }]
        },
        ads: {
            ads: devads_adDefinitions,
        },
        siteSection: {
            customId: "pga_live_desktop_turner_broadcast",
            pageRandom: "1531146546",
            videoPlayer: {
                videoAsset: {
                    eventCallbacks: [{
                        url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&cn=videoView&et=i&uxnw=&uxss=&uxct=",
                        name: "videoView",
                        type: "IMPRESSION",
                        use: "OVERRIDE",
                        showBrowser: false,
                        trackingUrls: []
                    }],
                    customId: "pga-live-broadcast",
                    random: "1531146546",
                    networkId: "42448",
                    adSlots: [{
                        eventCallbacks: [{
                                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&cn=slotImpression&et=i&tpos=55&init=1&slid=0",
                                name: "slotImpression",
                                type: "IMPRESSION",
                                use: "OVERRIDE",
                                showBrowser: false,
                                trackingUrls: []
                            },
                            {
                                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&cn=slotEnd&et=i&tpos=55&init=1&slid=0",
                                name: "slotEnd",
                                type: "IMPRESSION",
                                use: "OVERRIDE",
                                showBrowser: false,
                                trackingUrls: []
                            }
                        ],
                        customId: "1635",
                        // THIS IS THE SECTION WHERE THE TIMING NEEDS TO BE ADJUSTED
                        /************
                         * These are the lines you're looking for
                         *************/
                        selectedAds: devads_getSelectedAds(duration),
                        timePosition: time,
                        timePositionClass: "midroll",
                        adUnit: "midroll",
                    }, ]
                },
                adSlots: []
            },
            adSlots: []
        }
    };

    return data;
}

function devads_getSelectedAds(duration) {
    var timeLeft = duration;
    var selectedAds = [];
    var selectionCount = 0;

    while (timeLeft > 0) {
        var ad = devads_getNextAdOnRotation(selectionCount);
        var duration = devads_getAdDurationById(ad.adId);

        var timeLeftAfterAd = timeLeft - duration;

        if (timeLeftAfterAd >= 0) {
            selectedAds.push(ad);
            timeLeft = timeLeftAfterAd;
        }

        selectionCount++;
    }

    return selectedAds;
}

function devads_getNextAdOnRotation(index) {
    var adIndex = 0;

    if (devads_availableAds.length > 1) {
        adIndex = index % (devads_availableAds.length - 1)
    }

    return devads_availableAds[adIndex];
}

function devads_getAdDurationById(id) {
    var adDefMatch = devads_adDefinitions.filter(function(def) {
        return def.adId === id;
    })[0];

    // Give it a base duration to ensure no infinite loops
    var duration = 15;

    if (adDefMatch != null && adDefMatch.creatives[0] != null) {
        duration = adDefMatch.creatives[0].duration;
    }
    
    return duration;
    
}


// Ad Selections

var devads_availableAds = [
    // Offending VPAID Ad - GEICO
    // {
    //     eventCallbacks: [{
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554546&reid=10572761&arid=0&iw=&uxnw=&uxss=&uxct=",
    //             type: "GENERIC",
    //             use: "BASE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554546&reid=10572761&arid=0&auid=&cn=defaultImpression&et=i&_cc=25554546,10572761,,,1531146546,1&tpos=55&iw=&uxnw=&uxss=&uxct=&init=1&cr=",
    //             name: "defaultImpression",
    //             type: "IMPRESSION",
    //             use: "OVERRIDE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554546&reid=10572761&arid=0&auid=&cn=defaultClick&et=c&_cc=&tpos=55&cr=",
    //             name: "defaultClick",
    //             type: "CLICK",
    //             use: "OVERRIDE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         }
    //     ],
    //     adId: "25554546",
    //     creativeId: "3708958",
    //     replicaId: "0",
    //     networkId: "42448",
    //     creativeRenditionId: "10572761",
    //     companionAds: [],
    //     fallbackAds: []
    // }

    // Offending VPAID Ad - Ping
    {
        eventCallbacks: [{
                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554549&reid=10571830&arid=0&iw=&uxnw=&uxss=&uxct=",
                type: "GENERIC",
                use: "BASE",
                showBrowser: false,
                trackingUrls: []
            },
            {
                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554549&reid=10571830&arid=0&auid=&cn=defaultImpression&et=i&_cc=25554549,10571830,,,1531146546,1&tpos=55&iw=&uxnw=&uxss=&uxct=&init=1&cr=",
                name: "defaultImpression",
                type: "IMPRESSION",
                use: "OVERRIDE",
                showBrowser: false,
                trackingUrls: []
            },
            {
                url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554549&reid=10571830&arid=0&auid=&cn=defaultClick&et=c&_cc=&tpos=55&cr=",
                name: "defaultClick",
                type: "CLICK",
                use: "OVERRIDE",
                showBrowser: false,
                trackingUrls: []
            }
        ],
        adId: "25554549",
        creativeId: "3708952",
        replicaId: "0",
        networkId: "42448",
        creativeRenditionId: "10571830",
        companionAds: [],
        fallbackAds: [],
    },

    // Mercedes Non-VPAID Ad
    // {
    //     eventCallbacks: [{
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=22322352&reid=7627246&arid=0&iw=&uxnw=&uxss=&uxct=",
    //             type: "GENERIC",
    //             use: "BASE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=22322352&reid=7627246&arid=0&auid=&cn=defaultImpression&et=i&_cc=22322352,7627246,,,1531146546,1&tpos=55&iw=&uxnw=&uxss=&uxct=&init=1&cr=",
    //             name: "defaultImpression",
    //             type: "IMPRESSION",
    //             use: "OVERRIDE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=22322352&reid=7627246&arid=0&auid=&cn=defaultClick&et=c&_cc=&tpos=55&cr=http%3A\/\/www.turner.com",
    //             name: "defaultClick",
    //             type: "CLICK",
    //             use: "OVERRIDE",
    //             showBrowser: true,
    //             trackingUrls: []
    //         }
    //     ],
    //     adId: "22322352",
    //     creativeId: "2867212",
    //     replicaId: "0",
    //     networkId: "42448",
    //     creativeRenditionId: "7627246",
    //     companionAds: [],
    //     fallbackAds: [],
    // },

    // Degree Deodorant VPAID Ad
    // {
    //     eventCallbacks: [{
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554543&reid=10571730&arid=0&iw=&uxnw=&uxss=&uxct=",
    //             type: "GENERIC",
    //             use: "BASE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554543&reid=10571730&arid=0&auid=&cn=defaultImpression&et=i&_cc=25554543,10571730,,,1531146546,1&tpos=55&iw=&uxnw=&uxss=&uxct=&init=1&cr=",
    //             name: "defaultImpression",
    //             type: "IMPRESSION",
    //             use: "OVERRIDE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         },
    //         {
    //             url: "https:\/\/bea4.v.fwmrm.net\/ad\/l\/1?s=b148&n=42448%3B42448%3B378840%3B381962&t=1531146546386158022&f=&r=42448&adid=25554543&reid=10571730&arid=0&auid=&cn=defaultClick&et=c&_cc=&tpos=55&cr=",
    //             name: "defaultClick",
    //             type: "CLICK",
    //             use: "OVERRIDE",
    //             showBrowser: false,
    //             trackingUrls: []
    //         }
    //     ],
    //     adId: "25554543",
    //     creativeId: "3708932",
    //     replicaId: "0",
    //     networkId: "42448",
    //     creativeRenditionId: "10571730",
    //     companionAds: [],
    //     fallbackAds: [],
    // },
];

// Ad Definitions

var devads_adDefinitions = [{
    adId: "22322352",
    noPreload: false,
    noLoad: false,
    adUnit: "14094",
    isWrapper: false,
    required: false,
    creatives: [{
        creativeId: "2867212",
        baseUnit: "video",
        duration: "30",
        creativeRenditions: [{
                creativeRenditionId: "7627246",
                creativeApi: "None",
                width: "576",
                height: "324",
                preference: "0",
                bitrate: "572",
                parameters: [],
                asset: {
                    id: "7551567",
                    name: "DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_576x324.mp4",
                    url: "https:\/\/amd-ssl.cdn.turner.com\/pga\/big\/ads\/2017\/07\/31\/DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_576x324.mp4",
                    contentType: "video\/mp4-h264",
                    mimeType: "video\/mp4",
                    bytes: "2123912",
                    deliveryMethod: "progressive"
                },
                otherAssets: []
            },
            {
                creativeRenditionId: "7627247",
                creativeApi: "None",
                width: "768",
                height: "432",
                preference: "0",
                bitrate: "1511",
                parameters: [],
                asset: {
                    id: "7551568",
                    name: "DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_768x432.mp4",
                    url: "https:\/\/amd-ssl.cdn.turner.com\/pga\/big\/ads\/2017\/07\/31\/DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_768x432.mp4",
                    contentType: "video\/mp4-h264",
                    mimeType: "video\/mp4",
                    bytes: "5611138",
                    deliveryMethod: "progressive"
                },
                otherAssets: []
            },
            {
                creativeRenditionId: "7627248",
                creativeApi: "None",
                width: "1280",
                height: "720",
                preference: "0",
                bitrate: "3550",
                parameters: [],
                asset: {
                    id: "7551569",
                    name: "DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_1280x720.mp4",
                    url: "https:\/\/amd-ssl.cdn.turner.com\/pga\/big\/ads\/2017\/07\/31\/DZMB7332000H_Perception_MY18_CLA_2WD_MSRP_30_1920x1080_10mb_1280x720.mp4",
                    contentType: "video\/mp4-h264",
                    mimeType: "video\/mp4",
                    bytes: "13180313",
                    deliveryMethod: "progressive"
                },
                otherAssets: []
            }
        ],
        parameters: [{
                name: "_fw_advertiser_name",
                value: "z_test3"
            },
            {
                name: "hulu_industry",
                value: ""
            },
            {
                name: "ias_parameters",
                value: "anID=928791;reqNetworkId=42448;adNetworkId=42448;advertiserId=17615;campaignId=22321623;ioId=22322031;ioExternalId=;placementId=22322351;adUnitId=14094;seriesId=;assetId=124143641;assetCustomId=pga-live-broadcast;siteId=g148074;sectionId=1952587;creativeId=2867212;renditionId= 7627246;renditionDuration=30;timePositionClass=midroll;pageType=;slotDim=1920x1080;slotId=1635;prof=turner_html5_pem2;cpxInd=cpx-non;transId=1531146546386158022"
            },
            {
                name: "moat",
                value: "42448;17615;22321623;22322351;2867212;;124143641;g148074;1952587;30"
            }
        ]
    }]
},
{
    adId: "25554549",
    noPreload: false,
    noLoad: false,
    adUnit: "14094",
    isWrapper: false,
    required: false,
    creatives: [{
        creativeId: "3708952",
        baseUnit: "video",
        duration: "15",
        creativeRenditions: [{
            creativeRenditionId: "10571830",
            wrapperType: "external\/vast-2",
            wrapperUrl: "https:\/\/fw.adsafeprotected.com\/vast\/fwjsvid\/st\/139597\/22391794\/skeleton.js?includeFlash=false&originalVast=https:\/\/ad.doubleclick.net\/ddm\/pfadx\/N4427.149036.TURNERSPORTSANDENTE\/B20654411.214795857;sz=0x0;ord=772539049;dc_lat=;dc_rdid=;tag_for_child_directed_treatment=;dcmt=text\/xml",
            creativeApi: "VPAID",
            width: "300",
            height: "250",
            preference: "0",
            adReplicaId: "0",
            parameters: [],
            asset: {
                id: "10490817",
                name: "Default Asset for Rendition",
                contentType: "text\/js_ref",
                mimeType: "text\/javascript",
                deliveryMethod: "progressive"
            },
            otherAssets: []
        }],
        parameters: [{
                name: "_fw_advertiser_name",
                value: "z_test7"
            },
            {
                name: "hulu_industry",
                value: ""
            },
            {
                name: "ias_parameters",
                value: "anID=928791;reqNetworkId=42448;adNetworkId=42448;advertiserId=49061;campaignId=25263769;ioId=25264731;ioExternalId=;placementId=25554548;adUnitId=14094;seriesId=;assetId=124143641;assetCustomId=pga-live-broadcast;siteId=g148074;sectionId=1952587;creativeId=3708952;renditionId= 10571830;renditionDuration=15;timePositionClass=midroll;pageType=;slotDim=1920x1080;slotId=1635;prof=turner_html5_pem2;cpxInd=cpx-non;transId=1531146546386158022"
            },
            {
                name: "moat",
                value: "42448;49061;25263769;25554548;3708952;;124143641;g148074;1952587;15"
            }
        ]
    }]
},
{
    adId: "25554543",
    noPreload: false,
    noLoad: false,
    adUnit: "14094",
    isWrapper: false,
    required: false,
    creatives: [{
        creativeId: "3708932",
        baseUnit: "video",
        duration: "15",
        creativeRenditions: [{
            creativeRenditionId: "10571730",
            wrapperType: "external\/vast-2",
            wrapperUrl: "https:\/\/svastx.moatads.com\/groupmunilevervideo5876034363\/Degree_-_UNE_DEG_056_Degree_Men_Leonidas_2018-24145804_js.xml",
            creativeApi: "VPAID",
            width: "1280",
            height: "720",
            preference: "0",
            parameters: [],
            asset: {
                id: "10490716",
                name: "Default Asset for Rendition",
                contentType: "text\/js_ref",
                mimeType: "text\/javascript",
                deliveryMethod: "progressive"
            },
            otherAssets: []
        }],
        parameters: [{
                name: "_fw_advertiser_name",
                value: "z_test7"
            },
            {
                name: "hulu_industry",
                value: ""
            },
            {
                name: "ias_parameters",
                value: "anID=928791;reqNetworkId=42448;adNetworkId=42448;advertiserId=49061;campaignId=25263769;ioId=25264731;ioExternalId=;placementId=25554542;adUnitId=14094;seriesId=;assetId=124143641;assetCustomId=pga-live-broadcast;siteId=g148074;sectionId=1952587;creativeId=3708932;renditionId= 10571730;renditionDuration=15;timePositionClass=midroll;pageType=;slotDim=1920x1080;slotId=1635;prof=turner_html5_pem2;cpxInd=cpx-non;transId=1531146546386158022"
            },
            {
                name: "moat",
                value: "42448;49061;25263769;25554542;3708932;;124143641;g148074;1952587;15"
            }
        ]
    }]
},
{
    adId: "25554546",
    noPreload: false,
    noLoad: false,
    adUnit: "14094",
    isWrapper: false,
    required: false,
    creatives: [{
        creativeId: "3708958",
        baseUnit: "video",
        duration: "15",
        creativeRenditions: [{
            creativeRenditionId: "10572761",
            wrapperType: "external\/vast-2",
            wrapperUrl: "https:\/\/ad.doubleclick.net\/ddm\/pfadx\/N6595.149036.TURNERSPORTSANDENTE\/B8431673.211130578;sz=0x0;ord=34918909;dc_lat=;dc_rdid=;tag_for_child_directed_treatment=;dcmt=text\/xml",
            creativeApi: "VPAID",
            width: "640",
            height: "360",
            preference: "0",
            adReplicaId: "0",
            parameters: [],
            asset: {
                id: "10491743",
                name: "Default Asset for Rendition",
                contentType: "text\/js_ref",
                mimeType: "text\/javascript",
                deliveryMethod: "progressive"
            },
            otherAssets: []
        }],
        parameters: [{
                name: "_fw_advertiser_name",
                value: "z_test7"
            },
            {
                name: "hulu_industry",
                value: ""
            },
            {
                name: "ias_parameters",
                value: "anID=928791;reqNetworkId=42448;adNetworkId=42448;advertiserId=49061;campaignId=25263769;ioId=25264731;ioExternalId=;placementId=25554545;adUnitId=14094;seriesId=;assetId=124143641;assetCustomId=pga-live-broadcast;siteId=g148074;sectionId=1952587;creativeId=3708958;renditionId= 10572761;renditionDuration=15;timePositionClass=midroll;pageType=;slotDim=1920x1080;slotId=1635;prof=turner_html5_pem2;cpxInd=cpx-non;transId=1531146546386158022"
            },
            {
                name: "moat",
                value: "42448;49061;25263769;25554545;3708958;;124143641;g148074;1952587;15"
            }
        ]
    }]
},

];