// Generates a midroll ad response with FW dev ads that start
// at the requested time and fill up an arbitrary break duration

(function devads_main() {
  var fwInstanceContext = "Context_" + (tv.freewheel.SDK._instanceCounter - 1);
  var fwInstance = tv.freewheel.SDK._instanceQueue[fwInstanceContext];

  var adQueryParams = TOP.utils.Url.parse(
    fwInstance._adRequest.generateTypeBRequestUrl()
  ).queryAsMap();

  if(adQueryParams.slau !== 'midroll') {
    fwInstance.requestComplete({});
    return;
  }

  var maxDuration = adQueryParams.maxd || '5';

  var adData = devads_generateAdResponse(
    parseFloat(adQueryParams.tpos, 10),
    parseFloat(maxDuration, 10)
  );

  fwInstance.requestComplete(adData);
})();

function devads_generateAdResponse(time, duration) {
  var data = {
    version: "1",
    networkId: "96749",
    serverId: "adbg-hls",
    timeElapsed: 19,
    timeRepository: "2018-02-20 18:30:11",
    timeAssetRepository: "2018-02-20 18:30:11",
    timeAssetLookup: 1,
    timeUserdbUserLookup: 4,
    timeLiveConnectUserLookup: 0,
    timeAllResellerUserLookup: 0,
    parameters: [
      {
        name: "testKey",
        category: "profile",
        value: "testValue"
      }
    ],
    rendererManifest: {
      adRenderers: {
        version: "1",
        adRenderer: [
          {
            name: "96749:VideoAdRenderer-js",
            url: "class://VideoRenderer",
            contentType:
              "video/mp4-h264,video/mp4,video/m4v,video/mov,video/mp4-mpeg4,video/mp4-mpeg4_simple,video/m4v-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video/mp4-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video/mov-h264_less_eq_level_3_baseline-640-480-less_eq_1500_kbps-aaclc,video/m4v-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video/mp4-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video/mov-h264_less_level_1.3_baseline-320-240-less_eq_768_kbps-aaclc,video/m4v-mpeg4-640-480-less_eq_2500_kbps-aaclc,video/mp4-mpeg4-640-480-less_eq_2500_kbps-aaclc,video/mov-mpeg4-640-480-less_eq_2500_kbps-aaclc,video/mp4-h264_less_eq_level_3.1_main-heaac,video/mp4-h264_less_eq_level_3.1_high-heaac,video/mp4-h264_less_eq_level_4.1_main-heaac,video/mp4-h264_less_eq_level_4.1_high-heaac,video/mov-h263,video/webm,",
            adUnit: "video,",
            slotType: "preroll,midroll,postroll,",
            creativeApi: "None,"
          },
          {
            name: "96749:VastTranslator-js",
            url: "class://tv.freewheel.SDK.VastTranslator",
            contentType: "external/vast,external/vast-2,external/vast-3,",
            adUnit: "video,fixed-size-interactive,",
            slotType: "preroll,midroll,postroll,overlay,",
            creativeApi: "VPAID,None,"
          },
          {
            name: "96749:TremorRenderer-js",
            url:
              "http://adm.fwmrm.net/p/vitest-js/tv.freewheel.renderer.TremorRenderer.js",
            contentType: "external/tremor-js,",
            adUnit: "video,",
            slotType: "preroll,",
            creativeApi: "None,"
          },
          {
            name: "96749:HTMLRenderer-js-temporal",
            url: "class://HTMLRenderer",
            contentType: "text/html_doc_ref,text/html_doc_lit_mobile,",
            adUnit:
              "video,still-image,fixed-size-interactive,app-interstitial,",
            slotType: "preroll,midroll,postroll,overlay,pause_midroll,",
            creativeApi: "MRAID-1.0,None,"
          },
          {
            name: "96749:FakeRenderer-js",
            url: "class://FakeRenderer",
            contentType: "text/browser-javascript,bbe/xml,",
            adUnit: "generic-overlay,",
            slotType: "display,",
            soAdUnit: "22766,22767,22768,",
            parameter: [
              {
                name: "testKey1",
                value: "testValue1"
              },
              {
                name: "testKey2",
                value: "testValue2"
              }
            ],
            creativeApi: "scripps,None,"
          },
          {
            name: "96749:VPAIDRenderer-js",
            url: "class://VPAIDRenderer",
            contentType: "text/js_ref,",
            adUnit: "video,fixed-size-interactive,",
            slotType: "preroll,midroll,postroll,overlay,",
            creativeApi: "VPAID,"
          },
          {
            name: "96749:HTMLRenderer-js-nowrapper",
            url: "class://HTMLRenderer",
            contentType: "text/html_lit_nowrapper,",
            adUnit: "fixed-size-interactive,",
            slotType: "display,",
            creativeApi: "None,"
          },
          {
            name: "96749:HTMLRenderer-js-display",
            url: "class://HTMLRenderer",
            contentType:
              "text/html_doc_ref,text/html_lit_js_wc_nw,text/html_doc_lit_mobile,",
            adUnit: "still-image,fixed-size-interactive,app-interstitial,",
            slotType: "display,",
            creativeApi: "MRAID-1.0,None,"
          }
        ]
      }
    },
    visitor: {
      httpHeaders: [],
      state: []
    },
    errors: {
      errors: []
    },
    eventCallbacks: {
      eventCallbacks: [
        {
          url:
            "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024",
          type: "GENERIC",
          use: "BASE",
          showBrowser: false,
          trackingUrls: []
        }
      ]
    },
    ads: {
      ads: [
        {
          adId: "9319159",
          noPreload: false,
          noLoad: false,
          adUnit: "14560",
          isWrapper: false,
          required: false,
          creatives: [
            {
              creativeId: "1394762",
              baseUnit: "video",
              duration: "5",
              creativeRenditions: [
                {
                  creativeRenditionId: "3059605",
                  creativeApi: "None",
                  width: "480",
                  height: "272",
                  preference: "0",
                  bitrate: "83",
                  parameters: [],
                  asset: {
                    id: "3016642",
                    name: "TestAd_5s_A.m4v",
                    url:
                      "http://m1.fwmrm.net/m/1/96749/74/1394762/3059605/TestAd_5s_A_1307692358.m4v",
                    contentType: "video/m4v",
                    mimeType: "video/m4v",
                    bytes: "425874",
                    deliveryMethod: "progressive"
                  },
                  otherAssets: []
                },
                {
                  creativeRenditionId: "3059606",
                  creativeApi: "None",
                  width: "480",
                  height: "272",
                  preference: "0",
                  parameters: [],
                  asset: {
                    id: "3016643",
                    name: "TestAd_5s_A.webm",
                    url:
                      "http://m1.fwmrm.net/m/1/96749/74/1394762/3059606/TestAd_5s_A_1338515819.webm",
                    contentType: "video/webm",
                    mimeType: "video/webm",
                    bytes: "118904",
                    deliveryMethod: "progressive"
                  },
                  otherAssets: []
                }
              ],
              parameters: []
            }
          ]
        }
      ]
    },
    siteSection: {
      customId: "DemoSiteGroup.01",
      pageRandom: "1519153181",
      videoPlayer: {
        videoAsset: {
          eventCallbacks: [
            {
              url:
                "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&cn=videoView&et=i&uxnw=&uxss=&uxct=",
              name: "videoView",
              type: "IMPRESSION",
              use: "OVERRIDE",
              showBrowser: false,
              trackingUrls: []
            }
          ],
          customId: "DemoVideoGroup.01",
          random: "1519153181",
          networkId: "96749",
          adSlots: [
            {
              eventCallbacks: [
                {
                  url:
                    "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&cn=slotImpression&et=i&tpos=10&init=1&slid=2",
                  name: "slotImpression",
                  type: "IMPRESSION",
                  use: "OVERRIDE",
                  showBrowser: false,
                  trackingUrls: []
                },
                {
                  url:
                    "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&cn=slotEnd&et=i&tpos=10&init=1&slid=2",
                  name: "slotEnd",
                  type: "IMPRESSION",
                  use: "OVERRIDE",
                  showBrowser: false,
                  trackingUrls: []
                }
              ],
              customId: "1.0.1.1660895612",
              compatibleDimensions: "630,1155",
              /************
               * These are the lines you're looking for
               *************/
              selectedAds: devads_getCreatives(
                Math.max(1, Math.floor(duration / 5))
              ),
              timePosition: time,
              timePositionClass: "midroll",
              adUnit: "js-mid1",
              source: "generated"
            }
          ]
        },
        adSlots: []
      },
      adSlots: []
    }
  };

  return data;
}

function devads_getCreatives(count) {
  return Array.apply(null, Array(count)).map(function() {
    return {
      eventCallbacks: [
        {
          url:
            "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&r=96749&adid=9319159&reid=3059605&arid=0&iw=&uxnw=&uxss=&uxct=",
          type: "GENERIC",
          use: "BASE",
          showBrowser: false,
          trackingUrls: []
        },
        {
          url:
            "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&r=96749&adid=9319159&reid=3059605&arid=0&auid=&cn=defaultImpression&et=i&_cc=9319159,3059605,,,1519153181,1&tpos=15&iw=&uxnw=&uxss=&uxct=&init=1&cr=",
          name: "defaultImpression",
          type: "IMPRESSION",
          use: "OVERRIDE",
          showBrowser: false,
          trackingUrls: []
        },
        {
          url:
            "http://demo.v.fwmrm.net/ad/l/1?s=adbg-hls&n=96749%3B96749&t=1519153181000103024&f=&r=96749&adid=9319159&reid=3059605&arid=0&auid=&cn=defaultClick&et=c&_cc=&tpos=15&cr=",
          name: "defaultClick",
          type: "CLICK",
          use: "OVERRIDE",
          showBrowser: false,
          trackingUrls: []
        }
      ],
      adId: "9319159",
      creativeId: "1394762",
      replicaId: "0",
      networkId: "96749",
      creativeRenditionId: "3059605",
      companionAds: [],
      fallbackAds: []
    };
  });
}
