//////////////////////
// Define
//////////////////////

var EventSignal1    = com.turner.top.lib.events.EventSignal1;
var EventResult     = com.turner.top.lib.events.EventResult;
var EventCollection = com.turner.top.lib.events.collection.EventCollection;

var milliseconds = 250; // time between dispatching


//////////////////////
// Event Types
//////////////////////

function TestEventType() {}
TestEventType.One   = ["One", 1];
TestEventType.Two   = ["Two", 2];
TestEventType.Three = ["Three", 3];


//////////////////////
// Event Signals
//////////////////////

function TestOneEvent()
{
    EventSignal1.call(this, TestEventType.One);
}
TestOneEvent.prototype             = Object.create(EventSignal1.prototype);
TestOneEvent.prototype.constructor = TestOneEvent;

function TestTwoEvent()
{
    EventSignal1.call(this, TestEventType.Two);
}
TestTwoEvent.prototype             = Object.create(EventSignal1.prototype);
TestTwoEvent.prototype.constructor = TestTwoEvent;

function TestThreeEvent()
{
    EventSignal1.call(this, TestEventType.Three);
}
TestThreeEvent.prototype             = Object.create(EventSignal1.prototype);
TestThreeEvent.prototype.constructor = TestThreeEvent;


//////////////////////
// Event Results
//////////////////////

function TestResult(value) {
    EventResult.call(this);
    this.value = value;
}
TestResult.prototype             = Object.create(EventResult.prototype);
TestResult.prototype.constructor = TestResult;


//////////////////////
// Event Collection
//////////////////////

function TestEventCollection() {
    EventCollection.call(this, [
        this.one   = new TestOneEvent(),
        this.two   = new TestTwoEvent(),
        this.three = new TestThreeEvent(),
    ]);
}
TestEventCollection.prototype             = Object.create(EventCollection.prototype);
TestEventCollection.prototype.constructor = TestEventCollection;


//////////////////////
// Helpers
//////////////////////

function getResultValue(event) {
    if (event instanceof TestOneEvent)   return 1;
    if (event instanceof TestTwoEvent)   return 2;
    if (event instanceof TestThreeEvent) return 3;
    return 0;
}


//////////////////////
// Logging
//////////////////////

var css =  'color: white; text-shadow: 1px 1px 8px rgba(0, 0, 0, 1)';

function log(/* ...args */)
{
    var args = [].slice.call(arguments);
    switch (args[0])
    {
        case 'dispatch':
            console.info('dispatch:', args[1]);
            break;

        case 'listen':
            console.log('%cstart listening', 'background: green;' + css);
            break;

        case 'unlisten':
            console.log('%cstop listening', 'background: red;' + css);
            break;

        case 'done':
            console.log('%cdone', 'background: orange;' + css);
            break;

        case 'cb':
            if (args.length === 3)
                console.log('%ccallback - type: [' + args[1] + '], result.value: ' + args[2].value, 'background: #01c301;' + css);
            else
                console.log('%ccallback - result.value: ' + args[1].value, 'background: #01c301;' + css);
            break;

        case 'before':
        case 'around':
        case 'after':
            console.log('%c' + args[0], 'background: #26d7d7;' + css);
            break;
        
        default: console.warn('unhandled log:', args);
    }
}