(function () {
    
    //////////////////////
    // Logging
    //////////////////////

    var colors = {
        listen  : 'green',
        unlisten: 'red',
        before  : '#07ecec',
        event   : 'orange',
        after   : '#0c9797',
        type    : '#de3333',
    };

    var styles = {
        name: 'background-color: {bgColor};' + 
              'color: white;' +
              'font-size: {fontSize}px;' + 
              'text-shadow: 2px 2px 1px rgba(0, 0, 0, 1)',
        id:   '',
        type: 'color: {color};'
    };

    window.log = function(name, type, id)
    {
        var msg = '%c {name} %c {id} %c{type}';
        
        if (id === null || id === undefined)
            msg = '%c {name} %c %c{type}';

        msg = msg.replace(/\{name\}/, name)
                 .replace(/\{id\}/,   id)
                 .replace(/\{type\}/, type);

        var styleName = styles.name
            .replace(/\{bgColor\}/, colors[name])
            .replace(/\{fontSize\}/, ['event', 'listen', 'unlisten'].includes(name) ? 20 : 12);
        var styleId   = styles.id;
        var styleType = styles.type
            .replace(/\{color\}/, colors.type);

        console.log(msg, styleName, styleId, styleType);
    };
    
    window.notTimeEvent = function(type)
    {
        return type != PlayerEventType.Media_Time_Changed
            && type != PlayerEventType.Ad_Time_Changed
            && type != PlayerEventType.Media_Timed_Metadata_Received;
    };
 }());
